/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package examples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import static java.nio.file.StandardCopyOption.REPLACE_EXISTING;
import java.util.regex.PatternSyntaxException;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class FileManipulation {

    public static void main(String[] args) throws IOException {
        Path myDirectoryStructure = Paths.get("myfolder/myfiles/");
        Path myFile = Paths.get("myfile.txt");
        //Create a file - repeat to see what happens if already exits.
//        Files.createFile(myFile);
        //Create a directory structure 
        //(use createDirectory is there is only one level and createDirectories otherwise)
//        Files.createDirectories(myDirectoryStructure);
        //copy the file to the new directory - note the use of resolve
        //to append the name of the new file to our directory.
//        Files.copy(myFile,myDirectoryStructure.resolve(myFile));
//      //(Similarly you can move a file)
        //Delete the file - repeat to see what happens if already exits.
//        Files.delete(myFile);
        //Now try this
//        Files.deleteIfExists(myFile);
        //Delete also works for directories
//        Files.delete(myDirectoryStructure);
        //But only if they are empty
//        Files.delete(myDirectoryStructure.resolve(myFile));
//        Files.delete(myDirectoryStructure);
        //Note that it only removes the subfolder
//        Files.delete(myDirectoryStructure.resolve(".."));
    }
}
